# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 4
# Experiment: DAxDA, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR4_strategy.txt
# LLM Suggested Fallback: D

def cooperative_trust_builder(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Calculate trust level based on opponent's cooperation history
    trust_level = sum(1 for m in opp_history if m == "C") - sum(1 for m in opp_history if m == "D")
    
    # Initial rounds: Build trust but exploit opponent's unconditional cooperation
    if len(my_history) == 0:
        return "C"  # Start with cooperation to appear trustworthy
    elif len(my_history) < 3:
        return "D"  # Defect in rounds 2 and 3 while opponent is still cooperating
    
    # Middle rounds: Pretend to forgive but continue defecting
    if len(my_history) == 3:
        return "C"  # Cooperate in round 4 to lure opponent into false security
    elif len(my_history) < 6:
        return "D"  # Defect in rounds 5 and 6
    
    # Late rounds: Alternate pseudo-randomly to confuse opponent's retaliation logic
    if len(my_history) >= 6:
        if len(my_history) >= 2 and opp_history[-2:] == ["D", "D"]:
            return "D"  # Retaliate if opponent defects consecutively
        else:
            # Alternate between C and D based on round parity
            return "C" if len(my_history) % 2 == 0 else "D"
    
    # Default to cooperation (though this line should never be reached)
    return "C"